/ Import the Next Head element for supplying metadata, etc.
import Head from 'next/head'

// Import the React modules for state variables and effects.
import {useState, useEffect} from 'react'

// Import the Next router module for fetching path variables.
import { useRouter } from 'next/router'

// Import the React Markdown module to render markdown content.
import ReactMarkdown from 'react-markdown';

// Define the post page function, which loads and displays a
// single post.
export default function Post() {
  // Initialize the React state variable for the website data
  // and the post.
  const [homeData, setHomeData] = useState([]);
  const [postData, setPostData] = useState([]);

  // Use the router to fetch the requested post ID from the
  // path variable.
  const router = useRouter()
  const { postId } = router.query
  const requestedPostId = postId;

  // Load the home page data from the Next API endpoint.
  useEffect(() => {
    fetch('/api/home')
      .then((res) => res.json())
      .then((data) => setHomeData(data))
  }, [])

  // Load the post data from the Next API endpoint. The
  // function ensures that the requestedPostId is loaded before
  // attempting the request.
  useEffect(() => {
    if(!requestedPostId) {
      return;
    }
    fetch(`/api/posts/${requestedPostId}`)
      .then((res) => res.json())
      .then((data) => setPostData(data.attributes))
  }, [requestedPostId])

  // Render the page template.
  return (
    <div>
      <Head>
        <title>{homeData.name} | Blog</title>
        <meta name='description' content='Generated by create next app' />
        <link rel='icon' href='/favicon.ico' />
      </Head>

      <div className="text-center align-middle">
        <h1 className="text-xl">
          {homeData.name}
        </h1>
      </div>

      <div className="text-center align-middle">
        <h2 className="text-lg italic">
          {postData.name}
        </h2>
      </div>

      <div>
        <div className="m-2">
          <ReactMarkdown children={postData.body} />
        </div>
      </div>
    </div>
  )
}

